// This is a simple I/O driver client for the const-fun module

// input format: 
//
// funcname arr_len arr_0 arr_1 ... arr_len-1 [n]**
//
// funcname: [one of even_odd, most_freq, longest_arith_prog, largest_sum_of_n]
// arr_len:  [must be <= 20 for this test client]
// n:        [only present if funcname is largest_sum_of_n is called]

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "cs136-trace.h"
#include "const-fun.h"

// this test client has a maximum array length of 20, but
// note that there is no such restriction on the module itself
const int MAXLEN = 20;

int main(void) {
  int cmd = 0;
  int arr[20] = {0};
  int len = 0;
  while (1) {
    cmd = read_symbol();
    if (scanf("%d", &len) != 1) {
      return EXIT_SUCCESS;
    }
    assert(1 <= len && len <= MAXLEN);
    for (int i = 0; i < len; ++i) {
      if (scanf("%d", &arr[i]) != 1) {
        return EXIT_SUCCESS;
      }
    }
    if (cmd == lookup_symbol("even_odd")) {
      int even = 0;
      int odd = 0;
      even_odd(arr, len, &even, &odd);
      printf("%d, %d\n", even, odd);
    } else if (cmd == lookup_symbol("most_freq")) { 
      printf("%d\n", most_freq(arr, len));
    } else if (cmd == lookup_symbol("longest_arith_prog")) {
      printf("%d\n", longest_arith_prog(arr, len));
    } else if (cmd == lookup_symbol("largest_sum_of_n")) {
      int n = 0;
      if (scanf("%d", &n) != 1) {
        return EXIT_SUCCESS;
      }
      printf("%d\n", largest_sum_of_n(arr, len, n));
    } else {
      return EXIT_SUCCESS;
    }
  }
}

