// This is a very simple test client for the mutable-fun module

// You will want to create your own test client(s) or modify this test client
// If you want to use I/O testing, you can look at q1 for ideas

#include <assert.h>
#include <stdbool.h>
#include <stdlib.h>
#include "mutable-fun.h"


// arrays_equal(a, b, len) determines if a and b are equivalent
// requires: a, b are valid arrays with the same length len [not asserted]
bool arrays_equal(const int a[], const int b[], int len) {
  assert(a);
  assert(b);
  assert(len > 0);
  for (int i = 0; i < len; ++i) {
    if (a[i] != b[i]) {
      return false;
    }
  }
  return true;
}

// flo_abs(a) returns |a|
double flo_abs(double a) {
   if (a < 0) {
     return -a;
   }
   return a;
}

// flo_within(a, b, epsilon) returns true if the differece between a and b
//   is strictly less than epsilon
double flo_within(double a, double b, double epsilon) {
  return flo_abs(a - b) < epsilon;   
}

int main(void) {

  int a[3] = {1, 3, 6};
  const int a_answer[3] = {7, 9, 12};
  add_max(a, 3);  
  assert(arrays_equal(a, a_answer, 3));
  
  int b[3] = {1, 3, 6};
  const int b_answer[3] = {1, 4, 10};
  partial_sums(b, 3);
  assert(arrays_equal(b, b_answer, 3));

  int c[4] = {1, 2, 3, 4};
  const int c_answer[4] = {2, 4, 1, 3};
  even_before_odd(c, 4);
  assert(arrays_equal(c, c_answer, 4));

  int d[3] = {1, 3, 6};
  struct stats s = {0};
  
  get_statistics(d, 3, &s);
  assert(s.min == 1);
  assert(s.max == 6);
  assert(flo_within(s.mean, 3.333, 0.001));
  assert(flo_within(s.median, 3.0, 0.01));
  assert(flo_within(s.variance, 6.333, 0.001));
  
}
